//------------------------------------------------------------------------------
// File: OutpostFood.cs
// Handles food trade outpost mission
// Author: Michael Felice
//------------------------------------------------------------------------------


// SCENARIO CALLBACK FUNCTIONS for Outpost Food Mission

// load scenario function (initializes the outpost food mission tasks)
function startOutpostFoodTasks()
{
   tsStartTask("OutpostFood", "OutpostFoodInit");
   
   // disable the train station upgrade
   tsEnableCommand(TrainStationUpgradeCmdData, false);
   
   // disable trains from moving on this map
   slgTrain_DisableTrains();
   
   // disable the quit scenario button
   $DisableQuitScenario = true;
}

// quit scenario function (turns off the outpost food task)
function quitOutpostFoodTasks()
{
   tsEndTask("OutpostFood");
   
   // disable food production
   tsEnableCommand(ProduceFoodCmdData, false);
   
   // check if the building should be unselected
   if (csIsCommandDisabled(ProduceGoldCmdData) == true &&
      csIsCommandDisabled(ProduceWoodCmdData) == true)
   {
      %object = nameToId("mapplatform");
      %building = slgQueryInterface(%object, $CID_BUILDING);
      %building.startExclusiveProduce($Resource::Count);
   }
   
   // reset the food trigger
   TaskModifier.strResetVertex("OutpostTasks", "OutpostTaskFoodTrigger");
   TaskModifier.strMarkVertex("OutpostTasks", "OutpostTaskFoodTrigger", $TSV_AVAIL);
   
   // resend the alert message
   SendOutpostTaskAlert("ID_TASKNAME_OUTPOSTFOOD", "id_outpost_food");
}



// MAIN SET OF TASKS

// explain the goal of the map, set up quests
function OutpostFoodInit::onExit(%vertex)
{
   // send the information
   tsSendTaskPopUpDlg("ID_TASKNAME_OUTPOSTFOOD", "id_outpostfood_intro",
      $TaskButton::Okay, HeroCharacter, "id_outpostfood_intro");
   
   // set up the quest
   tsAddQuestToTracker(true, "Outpost Food Mission",
      "Talk to " @ HeroCharacter.name @ " to find out what we need to do before we can import Food at our town's Outpost.",
      "Before you can start receiving shipments of Food in town, you will need to establish a source for your town's additional Food supply.",
      "Reward: Import Food at your Outpost and 10 Experience");
   tsReadyQuest("Outpost Food Mission");
}

// tell the player how to start the quest
function OutpostFoodStart::onExit(%vertex)
{
   // update the base quest information
   tsAddTaskToTracker("Outpost Food Mission", "Establish a source of additional Food.",
      "Complete all of the necessary tasks to establish a source of additional Food for your town.");
   
   // add the new tasks for building the farms and ranches
   tsAddTaskToTracker("Outpost Food Mission", "Build three Food production buildings.",
      "Build three Food production buildings (Farms and Ranches) and two Granaries to set up a source of Food.");
   tsAddTaskToTracker("Outpost Food Mission", "Build two Granaries.",
      "Build three Food production buildings (Farms and Ranches) and two Granaries to set up a source of Food.");
}



// HANDLES BUILDING AND DESTROYING THE FARMS

function HandleOtherFoodTasks()
{
   // check if the outpost task has been started yet
   if (OutpostFoodGranaryCreate2.isMarkedComplete() == true &&
      OutpostFoodOPStart1.isMarkedComplete() == false)
   {
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodOPStart1", $TSV_CMPLETE);
   }
   
   // check if the resource task has been started yet
   if (OutpostFoodGranaryCreate2.isMarkedComplete() == true &&
      OutpostFoodOPCreate.isMarkedComplete() == true &&
      OutpostFoodResourceStart1.isMarkedComplete() == false)
   {
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodResourceStart1", $TSV_CMPLETE);
   }
   
   // check if we are done
   if (OutpostFoodGranaryCreate2.isMarkedComplete() == true &&
      OutpostFoodOPCreate.isMarkedComplete() == true &&
      OutpostFoodResourceCreate.isMarkedComplete() == true)
   {
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodFarmDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodRanchDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodOPDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodResourceCreate", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodResourceDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodComplete1", $TSV_AVAIL);
   }
}

// this occurs when one farm has been created
function OutpostFoodFarmCreate1::onExit(%vertex)
{
   // check if this is the third production building
   if (OutpostFoodRanchCreate2.isMarkedComplete() == true)
   {
      tsCompleteTaskInTracker("Outpost Food Mission", "Build three Food production buildings.");
      HandleOtherFoodTasks();
   }
}

// this occurs when two farms have been created
function OutpostFoodFarmCreate2::onExit(%vertex)
{
   // check if this is the third production building
   if (OutpostFoodRanchCreate1.isMarkedComplete() == true)
   {
      tsCompleteTaskInTracker("Outpost Food Mission", "Build three Food production buildings.");
      HandleOtherFoodTasks();
   }
}

// this occurs when three farms have been created
function OutpostFoodFarmCreate3::onExit(%vertex)
{
   tsCompleteTaskInTracker("Outpost Food Mission", "Build three Food production buildings.");
   HandleOtherFoodTasks();
}

// this occurs when a farm is destroyed
function OutpostFoodFarmDestroy::onMessage(%vertex, %type, %param)
{
   // check if a farm is destroyed, and if not, do nothing
   Parent::onMessage(%vertex, %type, %param);
   if (%vertex.isMarkedComplete() == false)
   {
      return;
   }

   // pretend that this vertex was no affected (needs to be immediately
   // resolved, so the vertex is always active to receive messages)
   %vertex.decCompleteCount();
   TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodFarmDestroy", $TSV_AVAIL);
   
   // find out how many active farms are remaining
   %list = slgGetServerBuildingList();
   %count = %list.getSize();
   %farmCount = 0;
   for (%index = 0; %index < %count; %index++)
   {
      // get the object in the list
      %object = %list.getId(%index);
      
      // if the object datablock is not a farm, move to the next object
      %datablock = %object.getDataBlock();
      %name = %datablock.getName();
      if (%name !$= "Farm")
      {
         continue;
      }
      
      // if the farm is in the production state, add to the farm count
      %building = slgQueryInterface(%object, $CID_BUILDING);
      if (%building.getState() == $BuildingState::Production)
      {
         %farmCount++;
      }
   }
   
   // update the vertices based on how many farms are available
   switch (%farmCount)
   {
      case 0:
         // no farms are active
         TaskModifier.strResetVertex("OutpostFood", "OutpostFoodFarmCreate1");
         TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodFarmCreate1", $TSV_AVAIL);
         if (OutpostFoodRanchCreate3.isMarkedComplete() == false)
         {
            tsAddTaskToTracker("Outpost Food Mission", "Build three Food production buildings.",
               "Build three Food production buildings (Farms and Ranches) and two Granaries to set up a source of Food.");
         }

      case 1:
         // one farm is active
         TaskModifier.strResetVertex("OutpostFood", "OutpostFoodFarmCreate2");
         TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodFarmCreate2", $TSV_AVAIL);
         if (OutpostFoodRanchCreate2.isMarkedComplete() == false)
         {
            tsAddTaskToTracker("Outpost Food Mission", "Build three Food production buildings.",
               "Build three Food production buildings (Farms and Ranches) and two Granaries to set up a source of Food.");
         }

      case 2:
         // two farms are active
         TaskModifier.strResetVertex("OutpostFood", "OutpostFoodFarmCreate3");
         TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodFarmCreate3", $TSV_AVAIL);
         if (OutpostFoodRanchCreate1.isMarkedComplete() == false)
         {
            tsAddTaskToTracker("Outpost Food Mission", "Build three Food production buildings.",
               "Build three Food production buildings (Farms and Ranches) and two Granaries to set up a source of Food.");
         }
   }
}



// HANDLES BUILDING AND DESTROYING THE RANCHES

// this occurs when one ranch has been created
function OutpostFoodRanchCreate1::onExit(%vertex)
{
   // check if this is the third production building
   if (OutpostFoodFarmCreate2.isMarkedComplete() == true)
   {
      tsCompleteTaskInTracker("Outpost Food Mission", "Build three Food production buildings.");
      HandleOtherFoodTasks();
   }
}

// this occurs when two ranches have been created
function OutpostFoodRanchCreate2::onExit(%vertex)
{
   // check if this is the third production building
   if (OutpostFoodFarmCreate1.isMarkedComplete() == true)
   {
      tsCompleteTaskInTracker("Outpost Food Mission", "Build three Food production buildings.");
      HandleOtherFoodTasks();
   }
}

// this occurs when three ranches have been created
function OutpostFoodRanchCreate3::onExit(%vertex)
{
   tsCompleteTaskInTracker("Outpost Food Mission", "Build three Food production buildings.");
   HandleOtherFoodTasks();
}

// this occurs when a ranch is destroyed
function OutpostFoodRanchDestroy::onMessage(%vertex, %type, %param)
{
   // check if a ranch is destroyed, and if not, do nothing
   Parent::onMessage(%vertex, %type, %param);
   if (%vertex.isMarkedComplete() == false)
   {
      return;
   }

   // pretend that this vertex was no affected (needs to be immediately
   // resolved, so the vertex is always active to receive messages)
   %vertex.decCompleteCount();
   TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodRanchDestroy", $TSV_AVAIL);
   
   // find out how many active ranches are remaining
   %list = slgGetServerBuildingList();
   %count = %list.getSize();
   %ranchCount = 0;
   for (%index = 0; %index < %count; %index++)
   {
      // get the object in the list
      %object = %list.getId(%index);
      
      // if the object datablock is not a ranch, move to the next object
      %datablock = %object.getDataBlock();
      %name = %datablock.getName();
      if (%name !$= "Ranch")
      {
         continue;
      }
      
      // if the ranch is in the production state, add to the ranch count
      %building = slgQueryInterface(%object, $CID_BUILDING);
      if (%building.getState() == $BuildingState::Production)
      {
         %ranchCount++;
      }
   }
   
   // update the vertices based on how many ranches are available
   switch (%ranchCount)
   {
      case 0:
         // no ranches are active
         TaskModifier.strResetVertex("OutpostFood", "OutpostFoodRanchCreate1");
         TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodRanchCreate1", $TSV_AVAIL);
         if (OutpostFoodFarmCreate3.isMarkedComplete() == false)
         {
            tsAddTaskToTracker("Outpost Food Mission", "Build three Food production buildings.",
               "Build three Food production buildings (Farms and Ranches) and two Granaries to set up a source of Food.");
         }

      case 1:
         // one ranch is active
         TaskModifier.strResetVertex("OutpostFood", "OutpostFoodRanchCreate2");
         TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodRanchCreate2", $TSV_AVAIL);
         if (OutpostFoodFarmCreate2.isMarkedComplete() == false)
         {
            tsAddTaskToTracker("Outpost Food Mission", "Build three Food production buildings.",
               "Build three Food production buildings (Farms and Ranches) and two Granaries to set up a source of Food.");
         }

      case 2:
         // two ranches are active
         TaskModifier.strResetVertex("OutpostFood", "OutpostFoodRanchCreate3");
         TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodRanchCreate3", $TSV_AVAIL);
         if (OutpostFoodFarmCreate1.isMarkedComplete() == false)
         {
            tsAddTaskToTracker("Outpost Food Mission", "Build three Food production buildings.",
               "Build three Food production buildings (Farms and Ranches) and two Granaries to set up a source of Food.");
         }
   }
}



// HANDLES BUILDING AND DESTROYING THE GRANARIES

// this occurs when one granary has been created
function OutpostFoodGranaryCreate1::onExit(%vertex)
{
}

// this occurs when two granaries have been created
function OutpostFoodGranaryCreate2::onExit(%vertex)
{
   tsCompleteTaskInTracker("Outpost Food Mission", "Build two Granaries.");
   
   // check if the outpost task has been started yet
   if ((OutpostFoodFarmCreate1.isMarkedComplete() == true && OutpostFoodRanchCreate2.isMarkedComplete() == true ||
      OutpostFoodFarmCreate2.isMarkedComplete() == true && OutpostFoodRanchCreate1.isMarkedComplete() == true ||
      OutpostFoodFarmCreate3.isMarkedComplete() == true ||
      OutpostFoodRanchCreate3.isMarkedComplete() == true) &&
      OutpostFoodOPStart1.isMarkedComplete() == false)
   {
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodOPStart1", $TSV_CMPLETE);
   }
   
   // check if the resource task has been started yet
   if ((OutpostFoodFarmCreate1.isMarkedComplete() == true && OutpostFoodRanchCreate2.isMarkedComplete() == true ||
      OutpostFoodFarmCreate2.isMarkedComplete() == true && OutpostFoodRanchCreate1.isMarkedComplete() == true ||
      OutpostFoodFarmCreate3.isMarkedComplete() == true ||
      OutpostFoodRanchCreate3.isMarkedComplete() == true) &&
      OutpostFoodOPCreate.isMarkedComplete() == true &&
      OutpostFoodResourceStart1.isMarkedComplete() == false)
   {
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodResourceStart1", $TSV_CMPLETE);
   }
   
   // check if we are done
   if ((OutpostFoodFarmCreate1.isMarkedComplete() == true && OutpostFoodRanchCreate2.isMarkedComplete() == true ||
      OutpostFoodFarmCreate2.isMarkedComplete() == true && OutpostFoodRanchCreate1.isMarkedComplete() == true ||
      OutpostFoodFarmCreate3.isMarkedComplete() == true ||
      OutpostFoodRanchCreate3.isMarkedComplete() == true) &&
      OutpostFoodOPCreate.isMarkedComplete() == true &&
      OutpostFoodResourceCreate.isMarkedComplete() == true)
   {
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodFarmDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodRanchDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodOPDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodResourceCreate", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodResourceDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodComplete1", $TSV_AVAIL);
   }
}

// this occurs when a granary is destroyed
function OutpostFoodGranaryDestroy::onMessage(%vertex, %type, %param)
{
   // check if a ranch is destroyed, and if not, do nothing
   Parent::onMessage(%vertex, %type, %param);
   if (%vertex.isMarkedComplete() == false)
   {
      return;
   }

   // pretend that this vertex was no affected (needs to be immediately
   // resolved, so the vertex is always active to receive messages)
   %vertex.decCompleteCount();
   TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodGranaryDestroy", $TSV_AVAIL);
   
   // find out how many active granaries are remaining
   %list = slgGetServerBuildingList();
   %count = %list.getSize();
   %granaryCount = 0;
   for (%index = 0; %index < %count; %index++)
   {
      // get the object in the list
      %object = %list.getId(%index);
      
      // if the object datablock is not a granary, move to the next object
      %datablock = %object.getDataBlock();
      %name = %datablock.getName();
      if (%name !$= "Granary")
      {
         continue;
      }
      
      // if the granary is in the production state, add to the granary count
      %building = slgQueryInterface(%object, $CID_BUILDING);
      if (%building.getState() == $BuildingState::Production)
      {
         %granaryCount++;
      }
   }
   
   // update the vertices based on how many granaries are available
   switch (%granaryCount)
   {
      case 0:
         // no granaries are active
         TaskModifier.strResetVertex("OutpostFood", "OutpostFoodGranaryCreate1");
         TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodGranaryCreate1", $TSV_AVAIL);

      case 1:
         // one granary is active
         TaskModifier.strResetVertex("OutpostFood", "OutpostFoodGranaryCreate2");
         TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodGranaryCreate2", $TSV_AVAIL);
         tsAddTaskToTracker("Outpost Food Mission", "Build two Granaries.",
            "Build three Food production buildings (Farms and Ranches) and two Granaries to set up a source of Food.");
   }
}



// HANDLES UPGRADING AND DESTROYING THE OUTPOST

// when the previous conditions are met for the first time, and the
// platform needs to be upgraded
function OutpostFoodOPStart1::onExit(%vertex)
{
   // give the hero something to talk about
   tsSendTaskClickDlg("ID_TASKNAME_OUTPOSTFOOD", "id_outpostfood_platform",
      $TaskButton::Okay, HeroCharacter, "id_outpostfood_platform");
}

// set up the platform for the upgrade
function OutpostFoodOPStart2::onExit(%vertex)
{
   // update the quest information
   tsAddTaskToTracker("Outpost Food Mission", "Upgrade the Platform to an Outpost.",
      "Upgrade the Platform to an Outpost in order to ship Food back to town.");
}

// before the outpost can be created, the platform team needs to be set
function OutpostFoodOPCreate::onEnter(%vertex)
{
   // update the team of the platform
   resourcePlatform.setTeam($OST_PLAYER);
}

// this occurs when the outpost has been upgraded
function OutpostFoodOPCreate::onExit(%vertex)
{
   tsCompleteTaskInTracker("Outpost Food Mission", "Upgrade the Platform to an Outpost.");
   
   // check if the ranches and farms are also completed
   if ((OutpostFoodFarmCreate1.isMarkedComplete() == true && OutpostFoodRanchCreate2.isMarkedComplete() == true ||
      OutpostFoodFarmCreate2.isMarkedComplete() == true && OutpostFoodRanchCreate1.isMarkedComplete() == true ||
      OutpostFoodFarmCreate3.isMarkedComplete() == true ||
      OutpostFoodRanchCreate3.isMarkedComplete() == true) &&
      OutpostFoodGranaryCreate2.isMarkedComplete() == true &&
      OutpostFoodResourceStart1.isMarkedComplete() == false)
   {
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodResourceStart1", $TSV_CMPLETE);
   }
   
   %check = OutpostFoodResourceCreate.isMarkedComplete();
   
   // check if the tasks are done
   if ((OutpostFoodFarmCreate1.isMarkedComplete() == true && OutpostFoodRanchCreate2.isMarkedComplete() == true ||
      OutpostFoodFarmCreate2.isMarkedComplete() == true && OutpostFoodRanchCreate1.isMarkedComplete() == true ||
      OutpostFoodFarmCreate3.isMarkedComplete() == true ||
      OutpostFoodRanchCreate3.isMarkedComplete() == true) &&
      OutpostFoodGranaryCreate2.isMarkedComplete() == true &&
      OutpostFoodResourceCreate.isMarkedComplete() == true)
   {
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodFarmDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodRanchDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodOPDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodResourceCreate", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodResourceDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodComplete1", $TSV_AVAIL);
   }
}

// this occurs when the outpost is destroyed
function OutpostFoodOPDestroy::onMessage(%vertex, %type, %param)
{
   // check if the outpost is destroyed, and if not, do nothing
   Parent::onMessage(%vertex, %type, %param);
   if (%vertex.isMarkedComplete() == false)
   {
      return;
   }

   // pretend that this vertex was no affected (needs to be immediately
   // resolved, so the vertex is always active to receive messages)
   %vertex.decCompleteCount();
   TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodOPDestroy", $TSV_AVAIL);
   
   // if the outpost is lost, we know it is the player's outpost because
   // it is the only outpost on the map, so reactivate the outpost task
   TaskModifier.strResetVertex("OutpostFood", "OutpostFoodOPCreate");
   TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodOPCreate", $TSV_AVAIL);
   tsAddTaskToTracker("Outpost Food Mission", "Upgrade the Platform to an Outpost.",
      "Upgrade the Platform to an Outpost in order to ship Food back to town.");
}



// HANDLES RESOURCE COLLECTION

// after the farms, ranches, and outpost have been created, send
// a message for resource collection
function OutpostFoodResourceStart1::onExit(%vertex)
{
   // give the hero something to talk about
   tsSendTaskClickDlg("ID_TASKNAME_OUTPOSTFOOD", "id_outpostfood_resource",
      $TaskButton::Okay, HeroCharacter, "id_outpostfood_resource");
}

// set up messages for resource collection
function OutpostFoodResourceStart2::onExit(%vertex)
{
   // update the quest information
   tsAddTaskToTracker("Outpost Food Mission", "Collect 50 Food.",
      "A stockpile of 50 Food should be enough to begin sending Food back to town.");
}

// check if food resources have passed 50
function OutpostFoodResourceCreate::onUpdate(%vertex)
{
   // if not enough food has been collected, do nothing
   if (rsGetResourceCount($Resource::Food) < 50)
   {
      return;
   }
   
   // complete this step of resource collection
   TaskModifier.StrMarkVertex("OutpostFood", "OutpostFoodResourceCreate", $TSV_CMPLETE);
   TaskModifier.StrMarkVertex("OutpostFood", "OutpostFoodResourceDestroy", $TSV_AVAIL);
   
   // update the task to completion
   tsCompleteTaskInTracker("Outpost Food Mission", "Collect 50 Food.",
      "A stockpile of 50 Food should be enough to begin sending Food back to town.");
   
   // check if everything is complete
   if ((OutpostFoodFarmCreate1.isMarkedComplete() == true && OutpostFoodRanchCreate2.isMarkedComplete() == true ||
      OutpostFoodFarmCreate2.isMarkedComplete() == true && OutpostFoodRanchCreate1.isMarkedComplete() == true ||
      OutpostFoodFarmCreate3.isMarkedComplete() == true ||
      OutpostFoodRanchCreate3.isMarkedComplete() == true) &&
      OutpostFoodGranaryCreate2.isMarkedComplete() == true &&
      OutpostFoodOPCreate.isMarkedComplete() == true)
   {
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodFarmDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodRanchDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodOPDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodResourceCreate", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodResourceDestroy", $TSV_CLOSED);
      TaskModifier.strMarkVertex("OutpostFood", "OutpostFoodComplete1", $TSV_AVAIL);
   }
}

// check if food resources have falled below 50
function OutpostFoodResourceDestroy::onUpdate(%vertex)
{
   // if enough food has been collected, do nothing
   if (rsGetResourceCount($Resource::Food) >= 50)
   {
      return;
   }
   
   // reactivate this step of resource collection
   TaskModifier.StrMarkVertex("OutpostFood", "OutpostFoodResourceCreate", $TSV_AVAIL);
   TaskModifier.StrMarkVertex("OutpostFood", "OutpostFoodResourceDestroy", $TSV_CMPLETE);
   
   // update the task to incompletion
   tsAddTaskToTracker("Outpost Food Mission", "Collect 50 Food.",
      "A stockpile of 50 Food should be enough to begin sending Food back to town.");
}



// HANDLES OUTPOST FOOD COMPLETION

// notify the player that mission is done
function OutpostFoodComplete1::onEnter(%vertex)
{
   // give the hero something to talk about
   tsSendTaskPopUpDlg("ID_TASKNAME_OUTPOSTFOOD", "id_outpostfood_complete",
      $TaskButton::Okay, HeroCharacter, "id_outpostfood_complete");
}

// close the quests that have been completed and update experience
function OutpostFoodComplete1::onExit(%vertex)
{
   // complete the quest
   tsCompleteTaskInTracker("Outpost Food Mission", "Establish a source of additional Food.");
   
   // experience reward for completing the quest
   tsModifyResource($Resource::Experience, 10, true);
   SendProductionToClient(HeroCharacter, "10 experience");
}

// exit the satellite
function OutpostFoodComplete2::onExit(%vertex)
{
   // return from this satellite
   %scenario = new SLScenario()
   {
        stack = false;
   };
   LoadScenario(%scenario);
   
   // update the satellite flag
   mapsatellite_outpostfood.disabled = false;
   TaskModifier.strMarkVertex("Badgetasks", "OutpostTaskFoodComplete", $TSV_CMPLETE);
}
